/*
 * Decompiled with CFR 0.152.
 */
package ptqi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.ShopConfBuilder;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.tab.TabularLoader;
import cz.insophy.inplan.util.Formatter;
import cz.insophy.inplan.util.IdentityHashSet;
import cz.insophy.inplan.util.MathUtils;
import cz.insophy.inplan.util.NameUtils;
import cz.insophy.inplan.util.TimeSpan;
import cz.insophy.inplan.util.Triple;
import cz.insophy.inplan.util.Tuple;
import cz.insophy.inplan.util.WpCalUtils;
import cz.insophy.inplan.util.errlog.ErrorLog;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ptqi.model.AbstractTimetable;
import ptqi.model.Bom;
import ptqi.model.CooperationReturn;
import ptqi.model.CustomerRequest;
import ptqi.model.FictionProducts;
import ptqi.model.ManufOrder;
import ptqi.model.MatprodCat;
import ptqi.model.MatprodStock;
import ptqi.model.OperationCompleted;
import ptqi.model.PropertyDefinition;
import ptqi.model.PropertyValues;
import ptqi.model.Routing;
import ptqi.model.RoutingSameWorkplace;
import ptqi.model.SupplyRequest;
import ptqi.model.Timetable;
import ptqi.model.WeakFixation;
import ptqi.model.Workcenter;
import ptqi.model.Workplace;
import ptqi.model.WorkplaceRouting;
import ptqi.model.WorkplaceTimetable;

public class DataSrcImporter {
    static final String COOPERATION_CAP = "_cooperation";
    static final String COOP_RETURN_MAT_PREFIX = "_cooperation_return_";
    static final String ARTIFICIAL_CAP = "_art";
    static final int ARTIFICIAL_OP_NO = -1;
    static final String ARTIFICIAL_OP_NAME = "-1";
    static final String ORIG_PROD = "origProd";
    static final String PREPROD_HORIZON = "preprodHorizon";
    private static final boolean USE_MULTILEVEL_STOCK = false;
    static final int MULTILEVEL_BOUND_OPERATION_CONSUPMTION = -2;
    static final int MULTILEVEL_BOUND_OPERATION_PRODUCING = 9999999;
    static final String VIRTUAL_WORKCENTER = "__PLANTUNE__";
    private static final BiMap<Class<? extends Propertized>, String> PROPERTY_EFFECTIVITY_NAMES;
    private static final Pattern PROPERTY_ID_SEP;
    @Nonnull
    private final TabularLoader loader;
    @Nonnull
    private final ErrorLog errLog;
    @Nonnull
    private final Instant fixationTime;
    private Multimap<String, String> addrProducts;
    private Set<String> addrOrders;
    private Set<String> coopSrNames;
    private Map<Tuple<String, Integer>, CooperationReturnInfo> coopReturnInfos;
    @Nonnull
    private final Map<GorAction.Key, GorAction> gorActions;
    private final Map<String, Double> gorReqQties;
    private boolean sortActiongrams;

    public DataSrcImporter(@Nonnull TabularLoader loader, @Nonnull ErrorLog errLog, @Nonnull Instant fixationTime) {
        this.loader = loader;
        this.errLog = errLog;
        this.fixationTime = fixationTime;
        this.gorReqQties = Maps.newHashMap();
        this.gorActions = Maps.newHashMap();
        this.coopSrNames = Sets.newHashSet();
        this.coopReturnInfos = Maps.newHashMap();
        this.sortActiongrams = false;
    }

    private void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    @VisibleForTesting
    ShopConfiguration createShopConfiguration() throws Exception {
        this.gorActions.clear();
        this.coopReturnInfos.clear();
        this.coopSrNames.clear();
        this.loadAddrProducts();
        this.loadCooperationReturns();
        return new ShopConfImport().call();
    }

    public Superplan createEmptySuperplan() throws Exception {
        return new SuperplanImport(this.createShopConfiguration()).call();
    }

    @Nonnull
    public ErrorLog getErrLog() {
        return this.errLog;
    }

    private static String addrProductName(String productName, String orderName) {
        return productName + "_" + orderName;
    }

    private void loadAddrProducts() throws IOException {
        this.addrProducts = HashMultimap.create();
        this.addrOrders = Sets.newHashSet();
        for (Bom bom : this.loader.load(Bom.class)) {
            if (bom.materialBatchId == null) continue;
            this.addrProducts.put(bom.materialName, bom.materialBatchId);
            this.addrOrders.add(bom.materialBatchId);
        }
    }

    private void loadCooperationReturns() throws IOException {
        for (CooperationReturn ret : this.loader.load(CooperationReturn.class)) {
            if (ret.qty <= 1.0E-7) {
                this.errLog.add(0, "coop.non_positive_qty", "mo", ret.orderName, "op", ret.operationNo, "qty", ret.qty);
                continue;
            }
            CooperationReturnInfo cri = this.coopReturnInfos.computeIfAbsent(Tuple.create(ret.orderName, ret.operationNo), ignored -> new CooperationReturnInfo());
            if (cri.date < ret.returnDate) {
                cri.date = ret.returnDate;
                if (!Strings.isNullOrEmpty(ret.srName)) {
                    cri.srName = ret.srName;
                }
            }
            if (Strings.isNullOrEmpty(ret.srName)) continue;
            this.coopSrNames.add(ret.srName);
        }
    }

    private String cooperationReturnMaterialName(String orderName, int opNo) {
        return COOP_RETURN_MAT_PREFIX + orderName + "_" + opNo;
    }

    private void loadProperties(ShopConfiguration conf, Set<Class<? extends Propertized>> effectivities, TargetProvider targetProvider) throws IOException {
        for (PropertyValues v : this.loader.load(PropertyValues.class)) {
            String effName = v.effectivity.toLowerCase();
            Class eff = (Class)PROPERTY_EFFECTIVITY_NAMES.inverse().get(effName);
            if (eff == null) {
                this.errLog.add(1, "properties.eff_unknown", "effectivity", effName, "property", v.propertyName, "target", v.targetName);
                continue;
            }
            if (!effectivities.contains(eff)) continue;
            Optional<Propertized> t = targetProvider.getTarget(effName, v.targetName);
            if (t.isPresent()) {
                cz.insophy.inplan.property.PropertyDefinition pd = conf.getPropertyDefinition(eff, v.propertyName);
                if (pd != null) {
                    t.get().setProperty(pd, pd.getType().toValue(v.propertyValue));
                    continue;
                }
                this.errLog.add(1, "properties.name_unknown", "effectivity", effName, "property", v.propertyName, "target", v.targetName);
                continue;
            }
            this.errLog.add(1, "properties.target_unknown", "effectivity", effName, "property", v.propertyName, "target", v.targetName);
        }
    }

    @VisibleForTesting
    static <T> void collectComponent(T first, Set<T> component, Multimap<T, T> pairs) {
        component.add(first);
        for (T second : pairs.get(first)) {
            component.add(second);
            DataSrcImporter.collectComponent(second, component, pairs);
        }
        pairs.removeAll(first);
    }

    static {
        ImmutableBiMap.Builder bob = ImmutableBiMap.builder();
        bob.put(GeneralizedOrderRequest.class, "gor");
        bob.put(GeneralizedActionRequest.class, "gar");
        bob.put(cz.insophy.inplan.mrp.SupplyRequest.class, "sr");
        bob.put(cz.insophy.inplan.mrp.CustomerRequest.class, "cr");
        bob.put(Material.class, "material");
        bob.put(Product.class, "product");
        bob.put(cz.insophy.inplan.shop.Workplace.class, "workplace");
        bob.put(Action.class, "action");
        PROPERTY_EFFECTIVITY_NAMES = bob.build();
        PROPERTY_ID_SEP = Pattern.compile("\\$\\$");
    }

    private class ShopConfImport
    implements Callable<ShopConfiguration> {
        private static final String SAME_WP_SUCC = "sameWpSucc";
        private static final String MAX_UNITS = "maxUnits";
        Set<Class<? extends Propertized>> effectivities = ImmutableSet.of(cz.insophy.inplan.shop.Workplace.class, Material.class, Product.class, Action.class);
        private final ShopConfBuilder bob;
        private final Multimap<String, String> allAlternatives;
        private final Multimap<Tuple<String, String>, Integer> allActions;
        private final Set<String> knownWorkcenters;
        private final Map<Triple<String, String, Integer>, String> opCaps;
        private final Map<Triple<String, String, String>, Integer> maxUnits;
        private final Map<String, Long> preprodHorizons;
        private ShopConfiguration conf;
        private boolean coopWorkplaceCreated;
        private boolean artWorkplaceCreated;
        private final Set<String> validMOperationStates = ImmutableSet.of("PROPOSED", "RELEASED", "RUNNING", "PAUSED", "FINISHED", "CANCELLED", new String[0]);

        ShopConfImport() {
            this.bob = new ShopConfBuilder(ShopConfBuilder.CycleMode.BREAK_LOOPS, DataSrcImporter.this.errLog);
            this.allActions = TreeMultimap.create(Tuple.naturalComparator(), Ordering.natural());
            this.allAlternatives = HashMultimap.create();
            this.knownWorkcenters = Sets.newHashSet();
            this.opCaps = Maps.newHashMap();
            this.maxUnits = Maps.newHashMap();
            this.preprodHorizons = Maps.newHashMap();
        }

        @Nonnull
        private String getOpCapability(String productName, String alternative, int operationNo) {
            Triple<String, String, Integer> key = Triple.create(productName, alternative, operationNo);
            return this.opCaps.computeIfAbsent(key, k -> "_" + (this.opCaps.size() + 1));
        }

        @Nullable
        private String getExistingOpCapability(String productName, String alternative, int operationNo) {
            Triple<String, String, Integer> key = Triple.create(productName, alternative, operationNo);
            return this.opCaps.get(key);
        }

        private void importWorkplaces() throws IOException {
            class WorkplaceWithCaps {
                private String name;
                private String desc;
                private Set<String> caps = Sets.newHashSet();
                private String workcenter;

                WorkplaceWithCaps() {
                }
            }
            WorkplaceWithCaps wpc2;
            List<Workplace> workplaces = DataSrcImporter.this.loader.loadList(Workplace.class);
            workplaces.sort(Comparator.comparingInt(a -> a.workplaceOrder));
            LinkedHashMap<String, WorkplaceWithCaps> wps = Maps.newLinkedHashMapWithExpectedSize(workplaces.size());
            for (Workplace wp : workplaces) {
                if (wp.workplaceName.isEmpty()) {
                    DataSrcImporter.this.errLog.add(4, "wp.emtpy_name");
                    continue;
                }
                if (wp.workcenterName.isEmpty()) {
                    DataSrcImporter.this.errLog.add(4, "wp.emtpy_wc_name", "wp", wp.workplaceName);
                    continue;
                }
                wpc2 = new WorkplaceWithCaps();
                wpc2.name = wp.workplaceName;
                wpc2.desc = wp.workplaceDescription;
                wpc2.workcenter = wp.workcenterName;
                wpc2.caps.add(wp.workcenterName);
                wps.put(wp.workplaceName, wpc2);
            }
            for (WorkplaceRouting wr : DataSrcImporter.this.loader.load(WorkplaceRouting.class)) {
                wpc2 = (WorkplaceWithCaps)wps.get(wr.workplaceName);
                if (wpc2 == null) {
                    DataSrcImporter.this.errLog.add(4, "wpr.invalid_workplace", "wp", wr.workplaceName);
                    continue;
                }
                String cap = this.getOpCapability(wr.productName, wr.alternative, wr.operationNo);
                wpc2.caps.add(cap);
            }
            WorkplaceWithCaps virtualWpc = new WorkplaceWithCaps();
            virtualWpc.name = DataSrcImporter.VIRTUAL_WORKCENTER;
            virtualWpc.desc = DataSrcImporter.VIRTUAL_WORKCENTER;
            virtualWpc.workcenter = DataSrcImporter.VIRTUAL_WORKCENTER;
            virtualWpc.caps.add(DataSrcImporter.VIRTUAL_WORKCENTER);
            wps.put(DataSrcImporter.VIRTUAL_WORKCENTER, virtualWpc);
            for (WorkplaceWithCaps wpc2 : wps.values()) {
                this.bob.addWorkplace(wpc2.name, wpc2.caps, wpc2.desc);
                this.knownWorkcenters.add(wpc2.workcenter);
            }
        }

        private void importWorkcenters() throws IOException {
            List<Workcenter> workcenters = DataSrcImporter.this.loader.loadList(Workcenter.class);
            workcenters.sort(Comparator.comparingInt(a -> a.workcenterOrder));
            for (Workcenter wc : workcenters) {
                if (wc.workcenterName.isEmpty()) {
                    DataSrcImporter.this.errLog.add(4, "wc.emtpy_name");
                    continue;
                }
                if (this.knownWorkcenters.contains(wc.workcenterName)) continue;
                if (wc.numOfUnits <= 0) {
                    DataSrcImporter.this.errLog.add(4, "wc.illegal_num_of_units", "workcenter", wc.workcenterName, "units", wc.numOfUnits);
                    continue;
                }
                this.bob.addWorkcenter(wc.workcenterName, wc.workcenterName, wc.workcenterDescription, wc.numOfUnits);
            }
        }

        private void importMatprodCat() throws IOException {
            HashSet<String> products = Sets.newHashSet();
            for (Routing r : DataSrcImporter.this.loader.load(Routing.class)) {
                products.add(r.productName);
            }
            for (Bom b : DataSrcImporter.this.loader.load(Bom.class)) {
                products.add(b.productName);
            }
            block17: for (MatprodCat mc : DataSrcImporter.this.loader.load(MatprodCat.class)) {
                MatprodCatType type;
                if (mc.type == null) {
                    type = products.contains(mc.matprod) ? MatprodCatType.PRODUCT : MatprodCatType.MATERIAL;
                } else {
                    switch (mc.type.toLowerCase()) {
                        case "tool": {
                            type = MatprodCatType.TOOL;
                            break;
                        }
                        case "material": {
                            type = MatprodCatType.MATERIAL;
                            break;
                        }
                        case "product": {
                            type = MatprodCatType.PRODUCT;
                            break;
                        }
                        default: {
                            DataSrcImporter.this.errLog.add(3, "matprod.illegal_type", "matprod", mc.matprod, "type", mc.type);
                            continue block17;
                        }
                    }
                }
                if (type != MatprodCatType.PRODUCT && products.contains(mc.matprod)) {
                    DataSrcImporter.this.errLog.add(0, "matprod_cat.product_declared_as_material", "matprod", mc.matprod);
                    type = MatprodCatType.PRODUCT;
                } else if (type == MatprodCatType.PRODUCT && !products.contains(mc.matprod)) {
                    DataSrcImporter.this.errLog.add(0, "matprod_cat.material_declared_as_product", "matprod", mc.matprod);
                    type = MatprodCatType.MATERIAL;
                }
                if (mc.materialHorizon < 0.0) {
                    mc.materialHorizon = -1.0;
                }
                if (type != MatprodCatType.MATERIAL && mc.materialHorizon != -1.0) {
                    DataSrcImporter.this.errLog.add(0, "matprod_cat.illegal_material_horizon", "matprod", mc.matprod, "type", (Object)type);
                    mc.materialHorizon = -1.0;
                }
                if (mc.maxBatch > 0.0 && mc.minBatch > 0.0 && mc.maxBatch < mc.minBatch) {
                    DataSrcImporter.this.errLog.add(0, "matprod_cat.illegal_min_max_batch", "matprod", mc.matprod);
                    mc.maxBatch = 0.0;
                }
                if (mc.aggregationHorizon < 0.0) {
                    mc.aggregationHorizon = -1.0;
                }
                boolean tool = false;
                long materialHorizonMs = (long)(mc.materialHorizon * 8.64E7);
                long aggregationHorizonMs = (long)(mc.aggregationHorizon * 8.64E7);
                switch (type) {
                    case TOOL: {
                        tool = true;
                    }
                    case MATERIAL: {
                        this.bob.addMaterial(mc.matprod, mc.description, materialHorizonMs, mc.safetyStock, mc.minBatch, mc.maxBatch, aggregationHorizonMs, tool, !tool);
                        continue block17;
                    }
                    case PRODUCT: {
                        this.bob.addProduct(mc.matprod, mc.description, materialHorizonMs, mc.safetyStock, mc.minBatch, mc.maxBatch, aggregationHorizonMs);
                        for (String orderName : DataSrcImporter.this.addrProducts.get(mc.matprod)) {
                            String addrProductName = DataSrcImporter.addrProductName(mc.matprod, orderName);
                            this.bob.addProduct(addrProductName, mc.description, materialHorizonMs, mc.safetyStock, mc.minBatch, mc.maxBatch, aggregationHorizonMs);
                        }
                        if (!(mc.preprodHorizon > 0.0)) continue block17;
                        this.preprodHorizons.put(mc.matprod, (long)Math.ceil(mc.preprodHorizon * 8.64E7));
                        continue block17;
                    }
                }
                throw new IllegalStateException("Invalid MatprodCatType " + type);
            }
        }

        private void createCoopWorkplace() {
            if (!this.coopWorkplaceCreated) {
                this.bob.addWorkcenter("Kooperace", DataSrcImporter.COOPERATION_CAP, "", 1);
                this.coopWorkplaceCreated = true;
            }
        }

        private void createArtificialWorkplace() {
            if (!this.artWorkplaceCreated) {
                this.bob.addWorkcenter("Um\u011bl\u00e9", DataSrcImporter.ARTIFICIAL_CAP, "", 1);
                this.artWorkplaceCreated = true;
            }
        }

        private void addAction(Routing r, String capability) {
            long unitTimeMs = Math.round(r.unitCapacityConsumption * 1000.0);
            long rebuildTimeMs = Math.round(r.setupTime * 1000.0);
            long minTimeBefMs = Math.round(r.minTimeBefore * 1000.0);
            long minTimeAftMs = Math.round(r.minTimeAfter * 1000.0);
            this.bob.addAction(r.productName, r.alternative, "" + r.operationNo, r.operationDescription, capability, unitTimeMs, rebuildTimeMs, minTimeBefMs, minTimeAftMs, 0.01, r.divisible ? Action.Divisibility.DIVISIBLE : Action.Divisibility.INDIVISIBLE, r.transferBatch, 0.0);
            if (!Strings.isNullOrEmpty(r.mId)) {
                GorAction.Key key = new GorAction.Key(r.productName, r.alternative, "" + r.operationNo);
                DataSrcImporter.this.gorActions.put(key, new GorAction(r.mId, r.mOperationState));
            }
            if (r.maxUnits != 1) {
                this.maxUnits.put(Triple.create(r.productName, r.alternative, "" + r.operationNo), r.maxUnits);
            }
            this.allAlternatives.put(r.productName, r.alternative);
            this.allActions.put(Tuple.create(r.productName, r.alternative), r.operationNo);
        }

        private void addArtificialAction(@Nonnull String product, @Nonnull String alternative) {
            this.createArtificialWorkplace();
            Routing r = new Routing();
            r.productName = product;
            r.alternative = alternative;
            r.operationNo = -1;
            r.operationDescription = "";
            r.workcenterName = DataSrcImporter.ARTIFICIAL_CAP;
            r.unitCapacityConsumption = 0.01;
            r.maxUnits = 1;
            r.setupTime = 0.005;
            r.divisible = true;
            r.minTimeBefore = 0.0;
            r.minTimeAfter = 0.0;
            r.transferBatch = 0.0;
            r.cooperationTime = 0.0;
            r.mOperationState = "PROPOSED";
            r.mId = DataSrcImporter.this.gorReqQties.containsKey(r.alternative) ? "0" : "";
            this.addAction(r, DataSrcImporter.ARTIFICIAL_CAP);
        }

        private double addArtificialActionForCompleteOop(@Nonnull String product, @Nonnull String alternative, int origOp, @Nonnull String material) {
            if (!this.allActions.get(Tuple.create(product, alternative)).contains(-1)) {
                this.addArtificialAction(product, alternative);
                DataSrcImporter.this.sortActiongrams = true;
            }
            GorAction ga = DataSrcImporter.this.gorActions.get(new GorAction.Key(product, alternative, DataSrcImporter.ARTIFICIAL_OP_NAME));
            ga.qty = DataSrcImporter.this.gorReqQties.get(alternative);
            DataSrcImporter.this.errLog.add(0, "bom.artificial_op_oop", "product", product, "alternative", alternative, "op", "" + origOp, "material", material);
            return ga.qty;
        }

        private void importRouting() throws IOException {
            for (Routing r : DataSrcImporter.this.loader.load(Routing.class)) {
                String opCap;
                Tuple<String, Integer> key;
                boolean isCoop = r.cooperationTime != null;
                CooperationReturnInfo coopReturnInfo = null;
                if (isCoop && (coopReturnInfo = DataSrcImporter.this.coopReturnInfos.get(key = Tuple.create(r.alternative, r.operationNo))) == null && r.cooperationTime <= 0.0) {
                    DataSrcImporter.this.errLog.add(0, "routing.illegal_coop_time", "product", r.productName, "alternative", r.alternative, "operation", r.operationNo, "coop_time", r.cooperationTime);
                    isCoop = false;
                }
                if (r.unitCapacityConsumption < 9.999E-4 && !isCoop) {
                    DataSrcImporter.this.errLog.add(3, "routing.illegal_ucc", "product", r.productName, "alternative", r.alternative, "operation", r.operationNo, "unit_cap", r.unitCapacityConsumption);
                    continue;
                }
                if (r.minTimeBefore < 0.0) {
                    DataSrcImporter.this.errLog.add(3, "routing.illegal_min_time_before", "product", r.productName, "alternative", r.alternative, "operation", r.operationNo, "mtb", r.minTimeBefore);
                    continue;
                }
                if (r.minTimeAfter < 0.0) {
                    DataSrcImporter.this.errLog.add(3, "routing.illegal_min_time_after", "product", r.productName, "alternative", r.alternative, "operation", r.operationNo, "mta", r.minTimeAfter);
                    continue;
                }
                if (r.setupTime < 0.0 && !isCoop) {
                    DataSrcImporter.this.errLog.add(3, "routing.illegal_setup_time", "product", r.productName, "alternative", r.alternative, "operation", r.operationNo, "setup_time", r.setupTime);
                    continue;
                }
                if (r.setupTime <= 1.0E-7) {
                    r.setupTime = 1.0;
                }
                if (r.mOperationState != null && !this.validMOperationStates.contains(r.mOperationState.toUpperCase())) {
                    DataSrcImporter.this.errLog.add(3, "routing.illegal_m_operation_state", "product", r.productName, "alternative", r.alternative, "operation", r.operationNo, "m_operation_state", r.mOperationState);
                    continue;
                }
                if (r.mOperationState != null && r.mOperationState.toUpperCase().equals("CANCELLED")) continue;
                if (r.maxUnits <= 0) {
                    r.maxUnits = -1;
                }
                if (DataSrcImporter.this.addrOrders.contains(r.alternative)) {
                    r.productName = DataSrcImporter.addrProductName(r.productName, r.alternative);
                }
                if ((opCap = this.getExistingOpCapability(r.productName, r.alternative, r.operationNo)) == null) {
                    opCap = r.workcenterName;
                }
                if (isCoop) {
                    this.createCoopWorkplace();
                    if (coopReturnInfo != null) {
                        r.minTimeBefore = 0.0;
                        coopReturnInfo.productName = r.productName;
                    } else {
                        r.minTimeBefore = r.cooperationTime;
                    }
                    r.minTimeAfter = 0.0;
                    r.unitCapacityConsumption = 0.01;
                    r.setupTime = 0.005;
                    r.transferBatch = -1.0;
                    opCap = DataSrcImporter.COOPERATION_CAP;
                }
                this.addAction(r, opCap);
            }
            this.addMultilevelProducingOperations();
            this.addMultilevelConsumingOperations();
            this.bob.sortActiongrams();
        }

        private void addMultilevelProducingOperations() {
            for (String matprod : DataSrcImporter.this.addrProducts.keySet()) {
                for (String orderName : DataSrcImporter.this.addrProducts.get(matprod)) {
                    String addrProductName = DataSrcImporter.addrProductName(matprod, orderName);
                    this.addMultilevelOperation(addrProductName, orderName, 9999999);
                }
            }
        }

        private void addMultilevelConsumingOperations() throws IOException {
            for (Bom bom : DataSrcImporter.this.loader.load(Bom.class)) {
                if (bom.materialBatchId == null || bom.alternative == null) continue;
                boolean addressed = DataSrcImporter.this.addrProducts.get(bom.productName).contains(bom.alternative);
                if (addressed) {
                    bom.productName = DataSrcImporter.addrProductName(bom.productName, bom.alternative);
                }
                if (this.allActions.get(Tuple.create(bom.productName, bom.alternative)).contains(-2)) continue;
                this.addMultilevelOperation(bom.productName, bom.alternative, -2);
            }
        }

        private void addMultilevelOperation(String addrProductName, String orderName, Integer operationNo) {
            Routing r = new Routing();
            r.productName = addrProductName;
            r.alternative = orderName;
            r.operationNo = operationNo;
            r.operationDescription = "";
            r.workcenterName = DataSrcImporter.VIRTUAL_WORKCENTER;
            r.unitCapacityConsumption = 0.01;
            r.maxUnits = 1;
            r.setupTime = 0.005;
            r.divisible = true;
            r.minTimeBefore = 0.0;
            r.minTimeAfter = 0.0;
            r.transferBatch = 0.0;
            r.cooperationTime = 0.0;
            r.mOperationState = "PROPOSED";
            r.mId = "0";
            this.addAction(r, DataSrcImporter.VIRTUAL_WORKCENTER);
        }

        private void importArtificialOps() throws IOException {
            for (Bom b : DataSrcImporter.this.loader.load(Bom.class)) {
                Collection<Integer> ops;
                if (b.alternative == null) continue;
                boolean addressed = DataSrcImporter.this.addrProducts.get(b.productName).contains(b.alternative);
                if (addressed) {
                    b.productName = DataSrcImporter.addrProductName(b.productName, b.alternative);
                }
                if (!(ops = this.allActions.get(Tuple.create(b.productName, b.alternative))).isEmpty() && (ops.size() != 1 || !ops.contains(9999999)) && (ops.size() != 1 || !ops.contains(-2))) continue;
                this.addArtificialAction(b.productName, b.alternative);
                DataSrcImporter.this.errLog.add(0, "bom.artificial_op", "product", b.productName, "alternative", b.alternative);
            }
        }

        private void importGorQties() throws IOException {
            for (ManufOrder mo : DataSrcImporter.this.loader.load(ManufOrder.class)) {
                DataSrcImporter.this.gorReqQties.put(mo.orderName, mo.qty);
            }
        }

        private void importGarQties() throws IOException {
            HashMap<Tuple<String, CallSite>, Double> oopQties = Maps.newHashMap();
            for (OperationCompleted oc : DataSrcImporter.this.loader.load(OperationCompleted.class)) {
                oopQties.put(Tuple.create(oc.orderName, "" + oc.operationNo), oc.completed);
            }
            Iterator<Map.Entry<GorAction.Key, GorAction>> iterator = DataSrcImporter.this.gorActions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<GorAction.Key, GorAction> entry = iterator.next();
                String orderName = entry.getKey().alternative;
                Double requestedQty = DataSrcImporter.this.gorReqQties.get(orderName);
                if (requestedQty != null) {
                    Tuple<String, String> oopKey = Tuple.create(orderName, entry.getKey().operation);
                    Double oopQty = (Double)oopQties.get(oopKey);
                    if (oopQty == null) {
                        oopQty = 0.0;
                    }
                    entry.getValue().qty = requestedQty - oopQty;
                    continue;
                }
                DataSrcImporter.this.errLog.add(3, "routing.unknown_order_name", "alternative", orderName);
                iterator.remove();
            }
        }

        private void importBomAlternative(@Nonnull Bom b, @Nonnull String alternative) {
            double qty;
            boolean addressed = DataSrcImporter.this.addrProducts.get(b.productName).contains(alternative);
            if (addressed) {
                b.productName = DataSrcImporter.addrProductName(b.productName, alternative);
            }
            if (b.operationNo == -1) {
                Collection<Integer> ops = this.allActions.get(Tuple.create(b.productName, alternative));
                ArrayList<Integer> opsWithoutVirtual = new ArrayList<Integer>(ops);
                opsWithoutVirtual.remove((Object)-2);
                opsWithoutVirtual.remove((Object)9999999);
                if (opsWithoutVirtual.isEmpty()) {
                    DataSrcImporter.this.errLog.add(2, "bom.no_first_op", "product", b.productName, "alternative", alternative);
                    return;
                }
                b.operationNo = (Integer)opsWithoutVirtual.iterator().next();
            }
            if (b.materialBatchId != null) {
                b.materialName = DataSrcImporter.addrProductName(b.materialName, b.materialBatchId);
                b.operationNo = -2;
                b.qtyRequested = DataSrcImporter.this.gorReqQties.get(b.materialBatchId);
            }
            GorAction ga = DataSrcImporter.this.gorActions.get(new GorAction.Key(b.productName, alternative, "" + b.operationNo));
            Optional<ShopConfBuilder.MatprodType> matprodType = this.bob.getMatprodType(b.materialName);
            if (matprodType.isPresent() && matprodType.get() == ShopConfBuilder.MatprodType.TOOL) {
                qty = b.qtyRequested;
            } else {
                if (matprodType.isEmpty()) {
                    this.bob.addMaterial(b.materialName, "", -1L, null, null, null, 0L, false, true);
                }
                if (ga == null) {
                    if (b.qtyFraction == 0.0) {
                        DataSrcImporter.this.errLog.add(2, "bom.invalid_qty_frac", "product", b.productName, "alternative", alternative, "material", b.materialName);
                        return;
                    }
                    qty = b.qtyRequested / b.qtyFraction;
                } else if (ga.qty > 1.0E-7) {
                    qty = b.qtyRequested / ga.qty;
                } else {
                    double gorReqQty = this.addArtificialActionForCompleteOop(b.productName, alternative, b.operationNo, b.materialName);
                    b.operationNo = -1;
                    qty = b.qtyRequested / gorReqQty;
                }
            }
            this.bob.addBom(b.productName, alternative, "" + b.operationNo, b.materialName, qty, 0.0);
        }

        private void importBom() throws IOException {
            for (Bom b : DataSrcImporter.this.loader.load(Bom.class)) {
                if (b.alternative == null) {
                    Collection<String> alts = this.allAlternatives.get(b.productName);
                    if (alts.isEmpty()) {
                        DataSrcImporter.this.errLog.add(2, "bom.unknown_product", "product", b.productName);
                    }
                    for (String alt : alts) {
                        if (b.operationNo != -1 && !this.allActions.get(Tuple.create(b.productName, alt)).contains(b.operationNo)) continue;
                        this.importBomAlternative(new Bom(b), alt);
                    }
                    continue;
                }
                this.importBomAlternative(b, b.alternative);
            }
            if (DataSrcImporter.this.sortActiongrams) {
                this.bob.sortActiongrams();
            }
        }

        private void addCoopBoms() {
            Iterator<Map.Entry<Tuple<String, Integer>, CooperationReturnInfo>> iterator = DataSrcImporter.this.coopReturnInfos.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Tuple<String, Integer>, CooperationReturnInfo> entry = iterator.next();
                String orderName = entry.getKey().getFirst();
                int opNo = entry.getKey().getSecond();
                CooperationReturnInfo cri = entry.getValue();
                GorAction ga = DataSrcImporter.this.gorActions.get(new GorAction.Key(cri.productName, orderName, "" + opNo));
                if (ga == null) continue;
                if (ga.qty <= 1.0E-7) {
                    iterator.remove();
                    continue;
                }
                cri.qty = ga.qty;
                String materialName = DataSrcImporter.this.cooperationReturnMaterialName(orderName, opNo);
                this.bob.addMaterial(materialName, "", -1L, 0.0, 0.0, null, 0L, false, true);
                this.bob.addBom(cri.productName, orderName, "" + opNo, materialName, 1.0, 0.0);
            }
        }

        private void importFictionProducts() throws IOException {
            for (FictionProducts fp : DataSrcImporter.this.loader.load(FictionProducts.class)) {
                String alternativeName = fp.fpAlternative;
                if (alternativeName == null) {
                    alternativeName = "*";
                }
                this.bob.addProducing(fp.fpName, alternativeName, null, fp.fpOutput, fp.qty, 0.0);
            }
        }

        private void importPropertyDefinitions() throws IOException {
            List<PropertyDefinition> pds = DataSrcImporter.this.loader.loadList(PropertyDefinition.class);
            ArrayList<cz.insophy.inplan.property.PropertyDefinition> pds2 = Lists.newArrayList();
            for (PropertyDefinition pd : pds) {
                Class eff = (Class)PROPERTY_EFFECTIVITY_NAMES.inverse().get(pd.effectivity.toLowerCase());
                if (eff == null) {
                    DataSrcImporter.this.errLog.add(2, "properties.illegal_effectivity", "effectivity", pd.effectivity, "property", pd.propertyName);
                    continue;
                }
                if (!this.effectivities.contains(eff)) continue;
                try {
                    PropertyDefinition.PropertyType type = PropertyDefinition.PropertyType.valueOf(pd.type);
                    pds2.add(new cz.insophy.inplan.property.PropertyDefinition(pd.propertyName, type, pd.label, pd.description, eff, pd.visible));
                }
                catch (IllegalArgumentException e) {
                    DataSrcImporter.this.errLog.add(2, "properties.illegal_type", "effectivity", pd.effectivity, "property", pd.propertyName, "type", pd.type);
                }
            }
            pds2.add(new cz.insophy.inplan.property.PropertyDefinition("m_id", PropertyDefinition.PropertyType.STRING, "m_id", "m_id", GeneralizedOrderRequest.class, false));
            pds2.add(new cz.insophy.inplan.property.PropertyDefinition("rcttm", PropertyDefinition.PropertyType.LONG, "rcttm", "rcttm", GeneralizedOrderRequest.class, false));
            pds2.add(new cz.insophy.inplan.property.PropertyDefinition("m_id", PropertyDefinition.PropertyType.STRING, "m_id", "m_id", GeneralizedActionRequest.class, false));
            pds2.add(new cz.insophy.inplan.property.PropertyDefinition("pullOrdering", PropertyDefinition.PropertyType.LONG, "pull", "pull", GeneralizedOrderRequest.class, false));
            pds2.add(new cz.insophy.inplan.property.PropertyDefinition("m_id", PropertyDefinition.PropertyType.STRING, "m_id", "m_id", cz.insophy.inplan.mrp.CustomerRequest.class, false));
            pds2.add(new cz.insophy.inplan.property.PropertyDefinition("weakFix", PropertyDefinition.PropertyType.STRING, "weakFix", "Weak Fixation Map", GeneralizedActionRequest.class, false));
            pds2.add(new cz.insophy.inplan.property.PropertyDefinition(SAME_WP_SUCC, PropertyDefinition.PropertyType.STRING, SAME_WP_SUCC, "Same Workplace Successor", Action.class, false));
            pds2.add(new cz.insophy.inplan.property.PropertyDefinition(MAX_UNITS, PropertyDefinition.PropertyType.LONG, MAX_UNITS, "Max Simultaneous Units", Action.class, false));
            pds2.add(new cz.insophy.inplan.property.PropertyDefinition(DataSrcImporter.PREPROD_HORIZON, PropertyDefinition.PropertyType.LONG, DataSrcImporter.PREPROD_HORIZON, "Allowed preproduction for product, in ms", Product.class, true));
            pds2.add(new cz.insophy.inplan.property.PropertyDefinition(DataSrcImporter.ORIG_PROD, PropertyDefinition.PropertyType.STRING, DataSrcImporter.ORIG_PROD, "Original product", GeneralizedOrderRequest.class, false));
            this.bob.addPropertyDefinitions(pds2);
        }

        private Optional<Propertized> getTarget(String effName, String id) {
            switch (effName) {
                case "workplace": {
                    return Optional.ofNullable(this.conf.getWorkplace(id));
                }
                case "material": 
                case "product": {
                    return Optional.ofNullable(this.conf.getMatprod(id));
                }
                case "action": {
                    String[] parts = PROPERTY_ID_SEP.split(id, -1);
                    if (parts.length == 3) {
                        Product product = this.conf.getProduct(parts[0]);
                        if (product == null) {
                            return Optional.empty();
                        }
                        Actiongram ag = product.getActiongram(parts[1]);
                        if (ag == null) {
                            return Optional.empty();
                        }
                        return Optional.ofNullable(ag.getActionByName(parts[2]));
                    }
                    return Optional.empty();
                }
            }
            throw new IllegalStateException("Unsupported effectivity " + effName);
        }

        private void importRoutingSameWorkplace() throws IOException {
            cz.insophy.inplan.property.PropertyDefinition sameWpSucc = this.conf.getPropertyDefinition(Action.class, SAME_WP_SUCC);
            for (Map.Entry<Tuple<Product, Actiongram>, Multimap<Action, Action>> entry : this.importSameWorkplacePairs().entrySet()) {
                Product p = entry.getKey().getFirst();
                Actiongram ag = entry.getKey().getSecond();
                Multimap<Action, Action> pairs = entry.getValue();
                block1: while (!pairs.isEmpty()) {
                    Action first = pairs.keySet().iterator().next();
                    List<cz.insophy.inplan.shop.Workplace> firstWps = this.conf.getWorkplaces(first.getCapabilityReq());
                    HashSet<Action> component = Sets.newHashSet();
                    DataSrcImporter.collectComponent(first, component, pairs);
                    ArrayList<Action> compList = Lists.newArrayListWithCapacity(component.size());
                    String capReq = first.getCapabilityReq();
                    for (Action a : component) {
                        List<cz.insophy.inplan.shop.Workplace> wps = this.conf.getWorkplaces(a.getCapabilityReq());
                        if (!a.getCapabilityReq().equals(capReq) && !wps.containsAll(firstWps)) {
                            DataSrcImporter.this.errLog.add(3, "rsw.conflicting_caps", "product", p.getName(), "alternative", ag.getName(), "op1", first.getName(), "op2", a.getName());
                            continue block1;
                        }
                        compList.add(a);
                    }
                    compList.sort(Comparator.comparing(ag::getActionOrder));
                    for (int i = 0; i < compList.size() - 1; ++i) {
                        ((Action)compList.get(i)).setProperty(sameWpSucc, ((Action)compList.get(i + 1)).getName());
                    }
                }
            }
        }

        @Nonnull
        private Map<Tuple<Product, Actiongram>, Multimap<Action, Action>> importSameWorkplacePairs() throws IOException {
            HashMap<Tuple<Product, Actiongram>, Multimap<Action, Action>> allPairs = Maps.newHashMap();
            for (RoutingSameWorkplace r : DataSrcImporter.this.loader.load(RoutingSameWorkplace.class)) {
                Product p = this.conf.getProduct(r.productName);
                if (p == null) {
                    DataSrcImporter.this.errLog.add(3, "rsw.unknown_product", "product", r.productName);
                    continue;
                }
                Actiongram ag = p.getActiongram(r.alternative);
                if (ag == null) {
                    DataSrcImporter.this.errLog.add(3, "rsw.unknown_alternative", "product", r.productName, "alternative", r.alternative);
                    continue;
                }
                if (r.firstOperationNo == r.secondOperationNo) {
                    DataSrcImporter.this.errLog.add(3, "rsw.same_first_second", "product", r.productName, "alternative", r.alternative, "op", r.firstOperationNo);
                    continue;
                }
                Action first = ag.getActionByName("" + r.firstOperationNo);
                if (first == null) {
                    DataSrcImporter.this.errLog.add(3, "rsw.unknown_first_op", "product", r.productName, "alternative", r.alternative, "op", r.firstOperationNo);
                    continue;
                }
                Action second = ag.getActionByName("" + r.secondOperationNo);
                if (second == null) {
                    DataSrcImporter.this.errLog.add(3, "rsw.unknown_second_op", "product", r.productName, "alternative", r.alternative, "op", r.secondOperationNo);
                    continue;
                }
                Multimap pairs = allPairs.computeIfAbsent(Tuple.create(p, ag), ignored -> HashMultimap.create());
                if (r.firstOperationNo > r.secondOperationNo) {
                    pairs.put(second, first);
                    continue;
                }
                pairs.put(first, second);
            }
            return allPairs;
        }

        private void setMaxUnitsProperties() {
            cz.insophy.inplan.property.PropertyDefinition maxUnitsPd = this.conf.getPropertyDefinition(Action.class, MAX_UNITS);
            for (Map.Entry<Triple<String, String, String>, Integer> entry : this.maxUnits.entrySet()) {
                Action a;
                Actiongram ag;
                String prod = entry.getKey().getFirst();
                String alt = entry.getKey().getSecond();
                String op = entry.getKey().getThird();
                long maxUnits = entry.getValue().intValue();
                Product product = this.conf.getProduct(prod);
                if (product == null || (ag = product.getActiongram(alt)) == null || (a = ag.getActionByName(op)) == null) continue;
                a.setProperty(maxUnitsPd, maxUnits);
            }
        }

        private void setPreprodHorizonProperties() {
            cz.insophy.inplan.property.PropertyDefinition preprodHorizonPd = this.conf.getPropertyDefinition(Product.class, DataSrcImporter.PREPROD_HORIZON);
            for (Map.Entry<String, Long> entry : this.preprodHorizons.entrySet()) {
                String prod = entry.getKey();
                Long preprodHorizon = entry.getValue();
                Product product = this.conf.getProduct(prod);
                if (product == null) continue;
                product.setProperty(preprodHorizonPd, preprodHorizon);
            }
        }

        @Override
        public ShopConfiguration call() throws Exception {
            DataSrcImporter.this.checkInterrupted();
            this.importPropertyDefinitions();
            DataSrcImporter.this.checkInterrupted();
            this.importWorkplaces();
            DataSrcImporter.this.checkInterrupted();
            this.importWorkcenters();
            DataSrcImporter.this.checkInterrupted();
            this.importMatprodCat();
            DataSrcImporter.this.checkInterrupted();
            this.importRouting();
            DataSrcImporter.this.checkInterrupted();
            this.importGorQties();
            DataSrcImporter.this.checkInterrupted();
            this.importArtificialOps();
            DataSrcImporter.this.checkInterrupted();
            this.importGarQties();
            DataSrcImporter.this.checkInterrupted();
            this.importBom();
            DataSrcImporter.this.checkInterrupted();
            this.addCoopBoms();
            DataSrcImporter.this.checkInterrupted();
            this.importFictionProducts();
            DataSrcImporter.this.checkInterrupted();
            this.conf = this.bob.build();
            DataSrcImporter.this.checkInterrupted();
            DataSrcImporter.this.loadProperties(this.conf, this.effectivities, this::getTarget);
            DataSrcImporter.this.checkInterrupted();
            this.importRoutingSameWorkplace();
            DataSrcImporter.this.checkInterrupted();
            this.setMaxUnitsProperties();
            this.setPreprodHorizonProperties();
            return this.conf;
        }
    }

    private class SuperplanImport
    implements Callable<Superplan> {
        private static final int STOCK_OFFSET_DAYS = 7;
        Set<Class<? extends Propertized>> effectivities = ImmutableSet.of(GeneralizedOrderRequest.class, GeneralizedActionRequest.class, cz.insophy.inplan.mrp.SupplyRequest.class, cz.insophy.inplan.mrp.CustomerRequest.class);
        private final Superplan superplan;
        private final ShopConfiguration conf;

        SuperplanImport(ShopConfiguration conf) {
            this.conf = conf;
            this.superplan = new Superplan(conf);
        }

        void importCrs() throws IOException {
            cz.insophy.inplan.property.PropertyDefinition mIdPd = this.conf.getPropertyDefinition(cz.insophy.inplan.mrp.CustomerRequest.class, "m_id");
            Preconditions.checkNotNull(mIdPd, "m_id CR property does not exist in given ShopConfiguration.");
            for (CustomerRequest cr : DataSrcImporter.this.loader.load(CustomerRequest.class)) {
                Material m3 = this.conf.getMatprod(cr.matprod);
                if (m3 == null) {
                    DataSrcImporter.this.errLog.add(2, "cr.invalid_matprod", "cr_name", cr.crName, "matprod", cr.matprod);
                    continue;
                }
                if (cr.qty <= 0.0) {
                    DataSrcImporter.this.errLog.add(2, "cr.invalid_qty", "cr_name", cr.crName, "qty", cr.qty);
                    continue;
                }
                cr.priority = this.fixPriority(cr.priority);
                cz.insophy.inplan.mrp.CustomerRequest c = new cz.insophy.inplan.mrp.CustomerRequest(cr.crName, m3, cr.dueDate, cr.qty, cr.priority);
                try {
                    this.superplan.addCustomerRequest(c);
                }
                catch (Exception e) {
                    DataSrcImporter.this.errLog.add(2, "cr.duplicate_id", "cr_name", cr.crName);
                }
                c.setProperties(Collections.singletonMap(mIdPd, cr.mId), this.conf.getPropertyDefinitionsInfoFor(cz.insophy.inplan.mrp.CustomerRequest.class));
            }
        }

        @Nonnull
        private Integer fixPriority(@Nullable Integer priority) {
            if (priority == null || priority > 10 || priority < 1) {
                return 10;
            }
            return priority;
        }

        void importSrs() throws IOException {
            for (SupplyRequest sr : DataSrcImporter.this.loader.load(SupplyRequest.class)) {
                if (DataSrcImporter.this.coopSrNames.contains(sr.srName)) continue;
                Material m3 = this.conf.getMatprod(sr.matprod);
                if (m3 == null) {
                    DataSrcImporter.this.errLog.add(2, "sr.invalid_matprod", "sr_name", sr.srName, "matprod", sr.matprod);
                    continue;
                }
                if (sr.qty <= 0.0) {
                    DataSrcImporter.this.errLog.add(2, "sr.invalid_qty", "sr_name", sr.srName, "qty", sr.qty);
                    continue;
                }
                cz.insophy.inplan.mrp.SupplyRequest s2 = new cz.insophy.inplan.mrp.SupplyRequest(sr.srName, m3, sr.dueDate, sr.qty, SupplyRequest.State.CONFIRMED);
                try {
                    this.superplan.addSupplyRequest(s2);
                }
                catch (Exception e) {
                    DataSrcImporter.this.errLog.add(2, "sr.duplicate_id", "sr_name", sr.srName);
                }
            }
        }

        private void addCooperationSrs() {
            for (Map.Entry<Tuple<String, Integer>, CooperationReturnInfo> entry : DataSrcImporter.this.coopReturnInfos.entrySet()) {
                String orderName = entry.getKey().getFirst();
                int opNo = entry.getKey().getSecond();
                CooperationReturnInfo cri = entry.getValue();
                String materialName = DataSrcImporter.this.cooperationReturnMaterialName(orderName, opNo);
                Material m3 = this.conf.getMatprod(materialName);
                if (m3 == null) {
                    DataSrcImporter.this.errLog.add(2, "coop.unlinked_return", "mo", orderName, "op", opNo);
                    continue;
                }
                SupplyRequest.State state = SupplyRequest.State.CONFIRMED;
                if (cri.srName == null) {
                    cri.srName = "_sr" + materialName;
                }
                cz.insophy.inplan.mrp.SupplyRequest s2 = new cz.insophy.inplan.mrp.SupplyRequest(cri.srName, m3, cri.date, cri.qty, state);
                try {
                    this.superplan.addSupplyRequest(s2);
                }
                catch (Exception e) {
                    DataSrcImporter.this.errLog.add(2, "sr.duplicate_id", "sr_name", cri.srName);
                }
            }
        }

        void importGors() throws IOException {
            cz.insophy.inplan.property.PropertyDefinition mIdPd = this.conf.getPropertyDefinition(GeneralizedOrderRequest.class, "m_id");
            Preconditions.checkNotNull(mIdPd, "m_id GOR property does not exist in given ShopConfiguration.");
            cz.insophy.inplan.property.PropertyDefinition garMIdPd = this.conf.getPropertyDefinition(GeneralizedActionRequest.class, "m_id");
            Preconditions.checkNotNull(garMIdPd, "m_id GAR property does not exist in given ShopConfiguration.");
            cz.insophy.inplan.property.PropertyDefinition origProdPd = this.conf.getPropertyDefinition(GeneralizedOrderRequest.class, DataSrcImporter.ORIG_PROD);
            Preconditions.checkNotNull(origProdPd, "origProd GOR property does not exist in given ShopConfiguration.");
            for (ManufOrder mo : DataSrcImporter.this.loader.load(ManufOrder.class)) {
                String origProd;
                Product p;
                if (DataSrcImporter.this.addrOrders.contains(mo.orderName)) {
                    p = this.conf.getProduct(DataSrcImporter.addrProductName(mo.productName, mo.orderName));
                    origProd = mo.productName;
                } else {
                    p = this.conf.getProduct(mo.productName);
                    origProd = null;
                }
                if (p == null) {
                    DataSrcImporter.this.errLog.add(2, "mo.invalid_product", "mo", mo.orderName, "product", mo.productName);
                    continue;
                }
                Actiongram ag = p.getActiongram(mo.alternative);
                if (ag == null) {
                    DataSrcImporter.this.errLog.add(2, "mo.invalid_alternative", "mo", mo.orderName, "alternative", mo.alternative);
                    continue;
                }
                if (mo.qty <= 0.0) {
                    DataSrcImporter.this.errLog.add(2, "mo.invalid_qty", "mo", mo.orderName, "qty", mo.qty);
                    continue;
                }
                mo.priority = this.fixPriority(mo.priority);
                GeneralizedOrderRequest gor = new GeneralizedOrderRequest(mo.orderName, p, mo.qty, mo.releaseDate, mo.dueDate, GeneralizedOrderRequest.State.RELEASED);
                gor.setActiongram(ag);
                gor.setActiongramLocked(true);
                gor.setPriority(mo.priority);
                try {
                    this.superplan.addGor(gor);
                }
                catch (Exception e) {
                    DataSrcImporter.this.errLog.add(2, "mo.duplicate_id", "mo", mo.orderName);
                    continue;
                }
                gor.setProperty(mIdPd, mo.mId);
                for (GeneralizedActionRequest gar : gor.getGars()) {
                    GorAction ga = DataSrcImporter.this.gorActions.get(new GorAction.Key(gor.getProduct().getName(), gor.getSelectedActiongram().getName(), gar.getAction().getName()));
                    if (ga != null) {
                        gar.setProperty(garMIdPd, ga.mId);
                        continue;
                    }
                    if (gar.getAction().getName().equals(DataSrcImporter.ARTIFICIAL_OP_NAME)) continue;
                    DataSrcImporter.this.errLog.add(2, "mo.cannot_set_op_mid", "mo", mo.orderName, "op", gar.getAction().getName());
                }
                if (origProd == null) continue;
                gor.setProperty(origProdPd, origProd);
            }
        }

        private Map<CapabilityIsland, Double> importDefaultWeekWcCapacities() throws IOException {
            IdentityHashMap<CapabilityIsland, Double> defaultWeekCaps = Maps.newIdentityHashMap();
            for (Workcenter wc : DataSrcImporter.this.loader.load(Workcenter.class)) {
                CapabilityIsland island = this.conf.getIsland(wc.workcenterName);
                if (island == null) continue;
                int units = island.getWorkplaces().size();
                double maxCap = 168.0 * (double)units;
                if (wc.weekCapacity == null || wc.weekCapacity < 0.0 || wc.weekCapacity > maxCap) {
                    wc.weekCapacity = maxCap;
                }
                defaultWeekCaps.put(island, wc.weekCapacity);
            }
            defaultWeekCaps.put(this.conf.getIsland(DataSrcImporter.VIRTUAL_WORKCENTER), 168.0);
            return defaultWeekCaps;
        }

        private Map<cz.insophy.inplan.shop.Workplace, Double> importDefaultWeekWpCapacities() throws IOException {
            IdentityHashMap<cz.insophy.inplan.shop.Workplace, Double> caps = Maps.newIdentityHashMap();
            for (Workplace mwp : DataSrcImporter.this.loader.load(Workplace.class)) {
                cz.insophy.inplan.shop.Workplace wp = this.conf.getWorkplace(mwp.workplaceName);
                if (wp == null) continue;
                if (mwp.weekCapacity == null || mwp.weekCapacity < 0.0 || mwp.weekCapacity > 168.0) {
                    mwp.weekCapacity = 168.0;
                }
                caps.put(wp, mwp.weekCapacity);
            }
            return caps;
        }

        private <T extends AbstractTimetable> Multimap<String, T> importTimetable(Class<T> cls, Function<T, String> nameExtractor, Function<T, Boolean> nameValidator) throws IOException {
            HashMultimap res = HashMultimap.create();
            for (AbstractTimetable tt : DataSrcImporter.this.loader.load(cls)) {
                if (tt.startTime > tt.endTime) {
                    DataSrcImporter.this.errLog.add(3, "timetable.invalid_start_end", "start", Formatter.formatLongDateTime(tt.startTime), "end", Formatter.formatLongDateTime(tt.endTime), "table", "_" + NameUtils.toConstantCase(cls.getSimpleName()), "subject", nameExtractor.apply(tt));
                    continue;
                }
                if (!nameValidator.apply(tt).booleanValue()) {
                    DataSrcImporter.this.errLog.add(3, "timetable.invalid_name", "table", "_" + NameUtils.toConstantCase(cls.getSimpleName()), "subject", nameExtractor.apply(tt));
                    continue;
                }
                res.put(nameExtractor.apply(tt), tt);
            }
            return res;
        }

        private <T extends AbstractTimetable> void applyTimetable(List<TimeSpan> offlines, Collection<T> ttsUnsorted, String logName, int nUnits) {
            if (ttsUnsorted == null || ttsUnsorted.isEmpty()) {
                return;
            }
            ArrayList<AbstractTimetable> tts = Lists.newArrayList(ttsUnsorted);
            tts.sort((o1, o2) -> {
                int res = Long.compare(o1.startTime, o2.startTime);
                if (res == 0) {
                    res = Long.compare(o2.endTime, o1.endTime);
                }
                return res;
            });
            for (AbstractTimetable tt : tts) {
                tt.capacityWorkDay = MathUtils.clamp(tt.capacityWorkDay, 0.0, 24 * nUnits);
                tt.capacitySaturday = MathUtils.clamp(tt.capacitySaturday, 0.0, 24 * nUnits);
                tt.capacitySunday = MathUtils.clamp(tt.capacitySunday, 0.0, 24 * nUnits);
                long workCap = (long)(tt.capacityWorkDay * 3600000.0 / (double)nUnits);
                long satCap = (long)(tt.capacitySaturday * 3600000.0 / (double)nUnits);
                long sunCap = (long)(tt.capacitySunday * 3600000.0 / (double)nUnits);
                List<TimeSpan> ttOnlines = WpCalUtils.createWeekCalendarTemplate(workCap, satCap, sunCap, logName);
                List<TimeSpan> ttOfflines = WpCalUtils.onlinesToOfflines(ttOnlines, tt.startTime, tt.endTime);
                TimeSpan.replace(offlines, tt.startTime, tt.endTime, ttOfflines);
            }
        }

        @Nonnull
        private String getWorkcenterName(cz.insophy.inplan.shop.Workplace wp) {
            String res = "";
            for (String cap : wp.getCapabilities()) {
                if (cap.startsWith("_")) continue;
                res = cap;
                break;
            }
            return res;
        }

        void importCalendars() throws IOException {
            Map<CapabilityIsland, Double> wcWeekCaps = this.importDefaultWeekWcCapacities();
            Map<cz.insophy.inplan.shop.Workplace, Double> wpWeekCaps = this.importDefaultWeekWpCapacities();
            Multimap<String, Timetable> wcTimetables = this.importTimetable(Timetable.class, tt -> tt.workcenterName, tt -> this.conf.getIsland(tt.workcenterName) != null);
            Multimap<String, WorkplaceTimetable> wpTimetables = this.importTimetable(WorkplaceTimetable.class, tt -> tt.workplaceName, tt -> this.conf.getWorkplace(tt.workplaceName) != null);
            ZonedDateTime midnight = ZonedDateTime.ofInstant(DataSrcImporter.this.fixationTime, ZoneId.systemDefault()).truncatedTo(ChronoUnit.DAYS);
            long from = midnight.minusWeeks(1L).toInstant().toEpochMilli();
            long to = midnight.plusMonths(6L).toInstant().toEpochMilli();
            for (CapabilityIsland island : this.conf.getIslands()) {
                int n = island.getWorkplaces().size();
                long unitWeekCap = island.getCapabilities().contains(DataSrcImporter.COOPERATION_CAP) || island.getCapabilities().contains(DataSrcImporter.ARTIFICIAL_CAP) ? 604800000L : (long)(wcWeekCaps.getOrDefault(island, 0.0) * 3600000.0 / (double)n);
                List<TimeSpan> wcOnlines = WpCalUtils.createDefaultCalendarTemplate(unitWeekCap, island.getName());
                for (cz.insophy.inplan.shop.Workplace wp : island.getWorkplaces()) {
                    Double weekCap = wpWeekCaps.get(wp);
                    List<TimeSpan> wpOnlines = weekCap == null ? wcOnlines : WpCalUtils.createDefaultCalendarTemplate((long)(weekCap * 3600000.0), wp.getName());
                    List<TimeSpan> offlines = WpCalUtils.onlinesToOfflines(wpOnlines, from, to);
                    this.applyTimetable(offlines, wcTimetables.get(this.getWorkcenterName(wp)), island.getName(), n);
                    this.applyTimetable(offlines, wpTimetables.get(wp.getName()), wp.getName(), 1);
                    for (TimeSpan o : offlines) {
                        this.superplan.addOffline(new OfflineActivity(o.getStart(), o.getEnd(), wp));
                    }
                }
            }
        }

        private void importStock() throws IOException {
            long stockTime = DataSrcImporter.this.fixationTime.minus(7L, ChronoUnit.DAYS).toEpochMilli();
            Plan plan = this.superplan.getPlan();
            for (MatprodStock ms : DataSrcImporter.this.loader.load(MatprodStock.class)) {
                Material m3 = this.conf.getMatprod(ms.matprod);
                if (m3 == null) {
                    DataSrcImporter.this.errLog.add(2, "stock.unknown_matprod", "material", ms.matprod);
                    continue;
                }
                if (ms.qty < 0.0) {
                    DataSrcImporter.this.errLog.add(2, "stock.illegal_qty", "material", ms.matprod, "qty", ms.qty);
                    continue;
                }
                if (!(ms.qty > 1.0E-7)) continue;
                plan.addActivity(new ExternalStoreActivity(stockTime, m3, ms.qty));
            }
        }

        void importCompleted() throws IOException {
            for (OperationCompleted oc : DataSrcImporter.this.loader.load(OperationCompleted.class)) {
                GeneralizedOrderRequest gor = this.superplan.getGor(oc.orderName);
                if (gor == null) {
                    DataSrcImporter.this.errLog.add(1, "completed.unknown_mo", "mo", oc.orderName);
                    continue;
                }
                GeneralizedActionRequest gar = gor.getGar("" + oc.operationNo);
                if (gar == null) {
                    DataSrcImporter.this.errLog.add(1, "completed.unknown_op", "mo", oc.orderName, "operation", oc.operationNo);
                    continue;
                }
                oc.completed = MathUtils.roundQtyWrtGranularityDown(oc.completed, 0.01);
                double newOop = gar.getOutOfPlanQty() + oc.completed;
                newOop = MathUtils.clamp(newOop, 0.0, gar.getRequestedQty());
                gar.setOutOfPlanMat(newOop);
                gar.setOutOfPlanQty(newOop);
            }
        }

        private Optional<Propertized> getTarget(String effName, String id) {
            switch (effName) {
                case "order": {
                    return Optional.ofNullable(this.superplan.getGor(id));
                }
                case "cr": {
                    return Optional.ofNullable(this.superplan.getCustomerRequest(id));
                }
                case "sr": {
                    return Optional.ofNullable(this.superplan.getSupplyRequest(id));
                }
                case "gar": {
                    String[] parts = PROPERTY_ID_SEP.split(id, -1);
                    if (parts.length == 2) {
                        GeneralizedOrderRequest gor = this.superplan.getGor(parts[0]);
                        if (gor == null) {
                            return Optional.empty();
                        }
                        GeneralizedActionRequest gar = gor.getGar(parts[1]);
                        return Optional.ofNullable(gar);
                    }
                    return Optional.empty();
                }
            }
            throw new IllegalStateException("Unsupported effectivity " + effName);
        }

        @VisibleForTesting
        void appendJsonString(StringBuilder sb, String s2) {
            sb.append('\"');
            int len = s2.length();
            for (int i = 0; i < len; ++i) {
                char ch = s2.charAt(i);
                if (ch < ' ') {
                    sb.append(String.format("\\u%04x", ch));
                    continue;
                }
                if (ch == '\\' || ch == '\"') {
                    sb.append('\\');
                }
                sb.append(ch);
            }
            sb.append('\"');
        }

        private boolean canFixFollowInSameWpRouting(Map<String, Integer> gar1Fix, Map<String, Integer> gar2Fix) {
            if (gar2Fix == null) {
                return true;
            }
            if (gar1Fix == null) {
                return false;
            }
            return gar2Fix.keySet().containsAll(gar1Fix.keySet());
        }

        private void removeWeakFixationConflicts(Map<GeneralizedActionRequest, Map<String, Integer>> fixations) {
            cz.insophy.inplan.property.PropertyDefinition sameWpSuccPd = this.conf.getPropertyDefinition(Action.class, "sameWpSucc");
            Preconditions.checkNotNull(sameWpSuccPd);
            IdentityHashSet<GeneralizedOrderRequest> gors = new IdentityHashSet<GeneralizedOrderRequest>();
            for (GeneralizedActionRequest gar : fixations.keySet()) {
                gors.add((GeneralizedOrderRequest)gar.getParent());
            }
            for (GeneralizedOrderRequest gor : gors) {
                for (GeneralizedActionRequest gar1 : gor.getGars()) {
                    Map<String, Integer> gar2Fix;
                    Map<String, Integer> gar1Fix;
                    GeneralizedActionRequest gar2;
                    String sameWpActionName = (String)gar1.getAction().getProperty(sameWpSuccPd);
                    if (sameWpActionName == null || (gar2 = gor.getGar(sameWpActionName)) == null || this.canFixFollowInSameWpRouting(gar1Fix = fixations.get(gar1), gar2Fix = fixations.get(gar2))) continue;
                    fixations.remove(gar2);
                    DataSrcImporter.this.errLog.add(1, "weak_fixation.routing_same_wp_conflict", "mo", gor.getId(), "op1", gar1.getAction().getName(), "op2", gar2.getAction().getName());
                }
            }
        }

        void importWeakFixation() throws IOException {
            HashSet<Triple<String, Integer, String>> knownKeys = Sets.newHashSet();
            IdentityHashMap<GeneralizedActionRequest, Map<String, Integer>> fixations = new IdentityHashMap<GeneralizedActionRequest, Map<String, Integer>>();
            for (WeakFixation wf : DataSrcImporter.this.loader.load(WeakFixation.class)) {
                List<GeneralizedActionRequest> gars;
                GeneralizedOrderRequest gor = this.superplan.getGor(wf.orderName);
                if (gor == null) {
                    DataSrcImporter.this.errLog.add(1, "weak_fixation.unknown_order", "mo", wf.orderName);
                    continue;
                }
                if (!knownKeys.add(Triple.create(wf.orderName, wf.operationNo, wf.workplaceName))) {
                    DataSrcImporter.this.errLog.add(1, "weak_fixation.duplicate_key", "mo", wf.orderName, "op", wf.operationNo, "wp", wf.workplaceName);
                    continue;
                }
                if (wf.operationNo == null) {
                    gars = gor.getGars();
                    wf.workplaceName = "";
                } else {
                    GeneralizedActionRequest gar2 = gor.getGar("" + wf.operationNo);
                    if (gar2 == null) {
                        DataSrcImporter.this.errLog.add(1, "weak_fixation.unknown_op", "mo", wf.orderName, "op", wf.operationNo);
                        continue;
                    }
                    gars = Collections.singletonList(gar2);
                }
                if (!Strings.isNullOrEmpty(wf.workplaceName)) {
                    cz.insophy.inplan.shop.Workplace wp = this.conf.getWorkplace(wf.workplaceName);
                    if (wp == null) {
                        DataSrcImporter.this.errLog.add(1, "weak_fixation.unknown_workplace", "mo", wf.orderName, "op", wf.operationNo, "wp", wf.workplaceName);
                        continue;
                    }
                    String cap = gars.get(0).getAction().getCapabilityReq();
                    if (!wp.hasCapability(cap)) {
                        DataSrcImporter.this.errLog.add(1, "weak_fixation.invalid_workplace", "mo", wf.orderName, "op", wf.operationNo, "wp", wf.workplaceName);
                        continue;
                    }
                }
                for (GeneralizedActionRequest gar3 : gars) {
                    Map garFixations = fixations.computeIfAbsent(gar3, x -> new HashMap());
                    garFixations.put(wf.workplaceName, wf.fixationOrder);
                }
            }
            this.removeWeakFixationConflicts(fixations);
            cz.insophy.inplan.property.PropertyDefinition wfPd = this.conf.getPropertyDefinition(GeneralizedActionRequest.class, "weakFix");
            Preconditions.checkState(wfPd != null, "weakFix property is not defined");
            fixations.forEach((gar, garFixation) -> {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                garFixation.forEach((wp, order) -> {
                    this.appendJsonString(sb, (String)wp);
                    sb.append(':');
                    sb.append(order.toString());
                    sb.append(',');
                });
                if (sb.length() > 1) {
                    sb.setLength(sb.length() - 1);
                }
                sb.append('}');
                gar.setProperty(wfPd, sb.toString());
            });
        }

        @Override
        public Superplan call() throws Exception {
            DataSrcImporter.this.checkInterrupted();
            this.importCrs();
            DataSrcImporter.this.checkInterrupted();
            this.importSrs();
            DataSrcImporter.this.checkInterrupted();
            this.addCooperationSrs();
            DataSrcImporter.this.checkInterrupted();
            this.importGors();
            DataSrcImporter.this.checkInterrupted();
            this.importCalendars();
            DataSrcImporter.this.checkInterrupted();
            this.importCompleted();
            DataSrcImporter.this.checkInterrupted();
            DataSrcImporter.this.loadProperties(this.conf, this.effectivities, this::getTarget);
            DataSrcImporter.this.checkInterrupted();
            this.importStock();
            DataSrcImporter.this.checkInterrupted();
            this.importWeakFixation();
            DataSrcImporter.this.checkInterrupted();
            this.superplan.setFixationDate(DataSrcImporter.this.fixationTime.toEpochMilli());
            return this.superplan;
        }
    }

    private static class CooperationReturnInfo {
        long date;
        String srName;
        double qty;
        String productName;

        private CooperationReturnInfo() {
        }
    }

    private static interface TargetProvider {
        public Optional<Propertized> getTarget(String var1, String var2);
    }

    private static enum MatprodCatType {
        PRODUCT,
        MATERIAL,
        TOOL;

    }

    private static class GorAction {
        final String mId;
        final String mOperationState;
        double qty = -1.0;

        GorAction(String mId, String mOperationState) {
            this.mId = mId;
            this.mOperationState = mOperationState;
        }

        static final class Key {
            final String product;
            final String alternative;
            final String operation;

            Key(String product, String alternative, String operation) {
                this.product = product;
                this.alternative = alternative;
                this.operation = operation;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key key = (Key)o;
                return Objects.equals(this.product, key.product) && Objects.equals(this.alternative, key.alternative) && Objects.equals(this.operation, key.operation);
            }

            public int hashCode() {
                return Objects.hash(this.product, this.alternative, this.operation);
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("product", this.product).add("alternative", this.alternative).add("operation", this.operation).toString();
            }
        }
    }
}

